<?php
defined('_JEXEC') or die('Restricted access');
/**
 * @package             Joomla
 * @subpackage          CoalaWeb Amazon Widgets
 * @author              Steven Palmer
 * @author url          http://cw.com
 * @author email        support@coalaweb.com
 * @license             GNU/GPL, see /assets/en-GB.license.txt
 * @copyright           Copyright (c) 2013 Steven Palmer All rights reserved.
 *
 * CoalaWeb Amazon Widgets is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
jimport('joomla.filesystem.folder');
jimport('joomla.filesystem.file');

class Com_CoalawebtrafficInstallerScript {

    /** @var string The component's name */
    protected $_coalaweb_extension = 'com_coalawebtraffic';
    protected $_new_module = 'mod_coalawebtraffic';

    /** @var string The old names */
    protected $_old_component = 'com_celtawebtraffic';
    protected $_old_module = 'mod_celtawebtraffic';

    /** @var array The list of extra modules and plugins to install */
    private $installation_queue = array(
        // modules => { (folder) => { (module) => { (position), (published) } }* }*
        'modules' => array(
            'admin' => array(
            ),
            'site' => array(
                'coalawebtraffic' => array('left', 0),
            )
        ),
        // plugins => { (folder) => { (element) => (published) }* }*
        'plugins' => array(
            'coalawebtraffic' => array(
            ),
            'content' => array(
            ),
            'system' => array(
                'cwtrafficcount' => 1,
                'cwtrafficclean' => 1,
            ),
        )
    );

    /** @var array Obsolete files and folders to remove */
    private $coalawebRemoveFiles = array(
        'files' => array(
            'administrator/language/en-GB/en-GB.com_celtawebtraffic.ini',
            'administrator/language/en-GB/en-GB.com_celtawebtraffic.sys.ini',
        ),
        'folders' => array(
            'administrator/components/com_celtawebtraffic',
            'components/com_celtawebtraffic',
            'media/com_celtawebtraffic',
        )
    );
    private $coalawebCliScripts = array(
    );

    /**
     * Joomla! pre-flight event
     * 
     * @param string $type Installation type (install, update, discover_install)
     * @param JInstaller $parent Parent object
     */
    public function preflight($type, $parent) {
        // Bugfix for "Can not build admin menus"
        if (in_array($type, array('install', 'discover_install'))) {
            $this->_bugfixDBFunctionReturnedNoError();
        } else {
            $this->_bugfixCantBuildAdminMenus();
        }

        // Only allow to install on Joomla! 2.5.0 or later
        return version_compare(JVERSION, '2.5.0', 'ge');
    }

    /**
     * Joomla! post-flight event
     * 
     * @param string $type install, update or discover_update
     * @param JInstaller $parent 
     */
    function postflight($type, $parent) {
        // Install subextensions
        $status = $this->_installSubextensions($parent);
        $this->_renameMoveParams();

        // Remove obsolete files and folders
        $this->_removeObsoleteFilesAndFolders($this->coalawebRemoveFiles);
        $this->_renameRemoveOldName();
        $this->_copyCliFiles($parent);

        // Show the post-installation page
        $this->_renderPostInstallation($status, $parent);
    }

    /**
     * Runs on uninstallation
     * 
     * @param JInstaller $parent 
     */
    function uninstall($parent) {
        // Uninstall subextensions
        $status = $this->_uninstallSubextensions($parent);

        // Show the post-uninstallation page
        $this->_renderPostUninstallation($status, $parent);
    }

    /**
     * Copies the CLI scripts into Joomla!'s cli directory
     * 
     * @param JInstaller $parent 
     */
    private function _copyCliFiles($parent) {
        if (!count($this->coalawebCliScripts))
            return;

        $src = $parent->getParent()->getPath('source');

        jimport("joomla.filesystem.file");
        jimport("joomla.filesystem.folder");

        foreach ($this->coalawebCliScripts as $script) {
            if (JFile::exists(JPATH_ROOT . '/cli/' . $script)) {
                JFile::delete(JPATH_ROOT . '/cli/' . $script);
            }
            if (JFile::exists($src . '/cli/' . $script)) {
                JFile::move($src . '/cli/' . $script, JPATH_ROOT . '/cli/' . $script);
            }
        }
    }

    /**
     * Renders the post-installation message 
     */
    private function _renderPostInstallation($status, $parent) {
        ?>

        <?php $rows = 1; ?>
        <link rel="stylesheet" href="../media/com_coalawebtraffic/css/com-coalaweb-base.css" type="text/css">
        <table id="newspaper-stats">
            <thead align="left">
                <tr>
                    <th class="title" colspan="2" align="left">Component</th>
                    <th width="30%">Status</th>
                </tr>
            </thead>
            <tbody>
                <tr class="row0">
                    <td class="key" colspan="2">
                        <?php echo JText::_('COM_COALAWEBTRAFFIC'); ?>
                    </td>
                    <td>
                        <strong style="color: green">Installed</strong>
                    </td>
                </tr>

                <?php if (count($status->modules)) : ?>
                    <tr>
                        <th>Module</th>
                        <th>Client</th>
                        <th width="30%">Status</th>
                    </tr>
                    <?php foreach ($status->modules as $module) : ?>
                        <tr class="row<?php echo ($rows++ % 2); ?>">
                            <td class="key"><?php echo JText::_($module['name']); ?></td>
                            <td class="key"><?php echo ucfirst($module['client']); ?></td>
                            <td><strong style="color: <?php echo ($module['result']) ? "green" : "red" ?>"><?php echo ($module['result']) ? 'Installed' : 'Not installed'; ?></strong></td>
                        </tr>
                    <?php endforeach; ?>
                <?php endif; ?>
                <?php if (count($status->plugins)) : ?>
                    <tr>
                        <th>Plugin</th>
                        <th>Group</th>
                        <th></th>
                    </tr>
                    <?php foreach ($status->plugins as $plugin) : ?>
                        <tr class="row<?php echo ($rows++ % 2); ?>">
                            <td class="key"><?php echo JText::_($plugin['name']); ?></td>
                            <td class="key"><?php echo ucfirst($plugin['group']); ?></td>
                            <td><strong style="color: <?php echo ($plugin['result']) ? "green" : "red" ?>"><?php echo ($plugin['result']) ? 'Installed' : 'Not installed'; ?></strong></td>
                        </tr>
                    <?php endforeach; ?>
                <?php endif; ?>
            </tbody>
        </table>
        <?php
    }

    private function _renderPostUninstallation($status, $parent) {
        ?>
        <?php $rows = 0; ?>
        <style type="text/css">
            #newspaper-stats {
                font-family: "Lucida Sans Unicode", "Lucida Grande", Sans-Serif;
                font-size: 12px;
                margin: 0 15px 15px;
                width: 50%;
                text-align: left;
                border-collapse: collapse;
                border: 1px solid #73B5D4;
            }

            #newspaper-stats { 
                margin: 7px 15px 15px;
                width: 95%;
            }
            #newspaper-stats img { 
                float: left;
                margin: 2px 5px 5px 0;
                width: auto;
            }

            #newspaper-stats th {
                padding: 12px 17px 12px 17px;
                font-weight: bold;
                font-size: 14px;
                color: #1272A5;
                border-bottom: 1px dashed #73B5D4;
            }

            #newspaper-stats td {
                padding: 7px 17px 7px 17px;
                color: #1272A5;
            }

            span.cw-slider h3 { 
                clear:both; 
                font-family: "Trebuchet MS", Helvetica, sans-serif; 
                font-size:22px; 
                margin:10px 15px; 
                padding:0px; 
                color:#333;  
                font-weight: normal; 
            }

        </style>
        <span class="cw-slider">
            <h3> CoalaWeb Traffic Uninstallation Status</h3>
        </span>
        <table id="newspaper-stats">
            <thead align="left">
                <tr>
                    <th class="title" colspan="2" align="left">Component</th>
                    <th width="30%">Status</th>
                </tr>
            </thead>
            <tbody>
                <tr class="row0">
                    <td class="key" colspan="2">CoalaWeb Traffic</td>
                    <td><strong style="color: green">Uninstalled</strong></td>
                </tr>

                <?php if (count($status->modules)) : ?>
                    <tr>
                        <th>Module</th>
                        <th>Client</th>
                        <th width="30%">Status</th>
                    </tr>
                    <?php foreach ($status->modules as $module) : ?>
                        <tr class="row<?php echo ($rows++ % 2); ?>">
                            <td class="key"><?php echo $module['name']; ?></td>
                            <td class="key"><?php echo ucfirst($module['client']); ?></td>
                            <td><strong style="color: <?php echo ($module['result']) ? "green" : "red" ?>"><?php echo ($module['result']) ? 'Uninstalled' : 'Not uninstalled'; ?></strong></td>
                        </tr>
                    <?php endforeach; ?>
                <?php endif; ?>
                <?php if (count($status->plugins)) : ?>
                    <tr>
                        <th>Plugin</th>
                        <th>Group</th>
                        <th></th>
                    </tr>
                    <?php foreach ($status->plugins as $plugin) : ?>
                        <tr class="row<?php echo ($rows++ % 2); ?>">
                            <td class="key"><?php echo ($plugin['name']); ?></td>
                            <td class="key"><?php echo ucfirst($plugin['group']); ?></td>
                            <td><strong style="color: <?php echo ($plugin['result']) ? "green" : "red" ?>"><?php echo ($plugin['result']) ? 'Uninstalled' : 'Not uninstalled'; ?></strong></td>
                        </tr>
                    <?php endforeach; ?>
                <?php endif; ?>
            </tbody>
        </table>
        <?php
    }

    /**
     * CoalaWeb Traffic 0.1.5+ remove old named extensions"
     */
    private function _renameRemoveOldName() {
        $db = JFactory::getDbo();

        // Remove old component
        // Remove old #__assets records
        $query = $db->getQuery(true);
        $query->select('id')
                ->from('#__assets')
                ->where($db->qn('name') . ' = ' . $db->q($this->_old_component));
        $db->setQuery($query);
        $ids = $db->loadColumn();
        if (!empty($ids))
            foreach ($ids as $id) {
                $query = $db->getQuery(true);
                $query->delete('#__assets')
                        ->where($db->qn('id') . ' = ' . $db->q($id));
                $db->setQuery($query);
                $db->query();
            }

        // Remove old #__extensions records
        $query = $db->getQuery(true);
        $query->select('extension_id')
                ->from('#__extensions')
                ->where($db->qn('element') . ' = ' . $db->q($this->_old_component));
        $db->setQuery($query);
        $ids = $db->loadColumn();
        if (!empty($ids))
            foreach ($ids as $id) {
                $query = $db->getQuery(true);
                $query->delete('#__extensions')
                        ->where($db->qn('extension_id') . ' = ' . $db->q($id));
                $db->setQuery($query);
                $db->query();
            }

        // Remove old #__menu records
        $query = $db->getQuery(true);
        $query->select('id')
                ->from('#__menu')
                ->where($db->qn('type') . ' = ' . $db->q('component'))
                ->where($db->qn('menutype') . ' = ' . $db->q('main'))
                ->where($db->qn('link') . ' LIKE ' . $db->q('index.php?option=' . $this->_old_component));
        $db->setQuery($query);
        $ids = $db->loadColumn();
        if (!empty($ids))
            foreach ($ids as $id) {
                $query = $db->getQuery(true);
                $query->delete('#__menu')
                        ->where($db->qn('id') . ' = ' . $db->q($id));
                $db->setQuery($query);
                $db->query();
            }

        //Remove old module
        $status = new JObject();
        $status->modules = array();
        // Find the module ID
        $sql = $db->getQuery(true)
                ->select($db->qn('extension_id'))
                ->from($db->qn('#__extensions'))
                ->where($db->qn('element') . ' = ' . $db->q($this->_old_module))
                ->where($db->qn('type') . ' = ' . $db->q('module'));
        $db->setQuery($sql);
        $id = $db->loadResult();
        // Uninstall the module
        if ($id) {
            $installer = new JInstaller;
            $result = $installer->uninstall('module', $id, 1);
            $status->modules[] = array(
                'name' => $this->_old_module,
                'client' => 'site',
                'result' => $result
            );
        }
    }

    /**
     * 
     */
    private function _renameMoveParams() {
        $db = JFactory::getDbo();

        $query = $db->getQuery(true);
        $query->select('extension_id')
                ->from('#__extensions')
                ->where($db->qn('element') . ' = ' . $db->q($this->_old_component));
        $db->setQuery($query);
        $idext = $db->loadColumn();
        if (!empty($idext)) {
            //Lets transfer the component settings from the old to the new
            $query = $db->getQuery(true);
            $query->update('#__extensions AS target');
            $query->leftJoin('#__extensions AS source ON source.element =' . $db->quote($this->_old_component));
            $query->set('target.params = source.params');
            $query->where('target.element =' . $db->quote($this->_coalaweb_extension));
            $db->setQuery($query);
            $db->query();
        }

        $query = $db->getQuery(true);
        $query->select('extension_id')
                ->from('#__extensions')
                ->where($db->qn('element') . ' = ' . $db->q($this->_old_module));
        $db->setQuery($query);
        $idmod = $db->loadColumn();
        if (!empty($idmod)) {
            //Lets transfer the module settings from the old to the new
            $query = $db->getQuery(true);
            $query->update('#__modules AS target');
            $query->leftJoin('#__modules AS source ON source.module =' . $db->quote($this->_old_module));
            $query->set('target.params = source.params');
            $query->set('target.title = source.title');
            $query->set('target.position= source.position');
            $query->set('target.published = source.published');
            $query->set('target.access = source.access');
            $query->set('target.showtitle = source.showtitle');
            $query->set('target.language = source.language');
            $query->where('target.module =' . $db->quote($this->_new_module));
            $db->setQuery($query);
            $db->query();
        }
    }

    /**
     * Joomla! 1.6+ bugfix for "DB function returned no error"
     */
    private function _bugfixDBFunctionReturnedNoError() {
        $db = JFactory::getDbo();

        // Fix broken #__assets records
        $query = $db->getQuery(true);
        $query->select('id')
                ->from('#__assets')
                ->where($db->qn('name') . ' = ' . $db->q($this->_coalaweb_extension));
        $db->setQuery($query);
        $ids = $db->loadColumn();
        if (!empty($ids))
            foreach ($ids as $id) {
                $query = $db->getQuery(true);
                $query->delete('#__assets')
                        ->where($db->qn('id') . ' = ' . $db->q($id));
                $db->setQuery($query);
                $db->query();
            }

        // Fix broken #__extensions records
        $query = $db->getQuery(true);
        $query->select('extension_id')
                ->from('#__extensions')
                ->where($db->qn('element') . ' = ' . $db->q($this->_coalaweb_extension));
        $db->setQuery($query);
        $ids = $db->loadColumn();
        if (!empty($ids))
            foreach ($ids as $id) {
                $query = $db->getQuery(true);
                $query->delete('#__extensions')
                        ->where($db->qn('extension_id') . ' = ' . $db->q($id));
                $db->setQuery($query);
                $db->query();
            }

        // Fix broken #__menu records
        $query = $db->getQuery(true);
        $query->select('id')
                ->from('#__menu')
                ->where($db->qn('type') . ' = ' . $db->q('component'))
                ->where($db->qn('menutype') . ' = ' . $db->q('main'))
                ->where($db->qn('link') . ' LIKE ' . $db->q('index.php?option=' . $this->_coalaweb_extension));
        $db->setQuery($query);
        $ids = $db->loadColumn();
        if (!empty($ids))
            foreach ($ids as $id) {
                $query = $db->getQuery(true);
                $query->delete('#__menu')
                        ->where($db->qn('id') . ' = ' . $db->q($id));
                $db->setQuery($query);
                $db->query();
            }
    }

    /**
     * Joomla! 1.6+ bugfix for "Can not build admin menus"
     */
    private function _bugfixCantBuildAdminMenus() {
        $db = JFactory::getDbo();

        // If there are multiple #__extensions record, keep one of them
        $query = $db->getQuery(true);
        $query->select('extension_id')
                ->from('#__extensions')
                ->where($db->qn('element') . ' = ' . $db->q($this->_coalaweb_extension));
        $db->setQuery($query);
        $ids = $db->loadColumn();
        if (count($ids) > 1) {
            asort($ids);
            $extension_id = array_shift($ids); // Keep the oldest id

            foreach ($ids as $id) {
                $query = $db->getQuery(true);
                $query->delete('#__extensions')
                        ->where($db->qn('extension_id') . ' = ' . $db->q($id));
                $db->setQuery($query);
                $db->query();
            }
        }

        // If there are multiple assets records, delete all except the oldest one
        $query = $db->getQuery(true);
        $query->select('id')
                ->from('#__assets')
                ->where($db->qn('name') . ' = ' . $db->q($this->_coalaweb_extension));
        $db->setQuery($query);
        $ids = $db->loadObjectList();
        if (count($ids) > 1) {
            asort($ids);
            $asset_id = array_shift($ids); // Keep the oldest id

            foreach ($ids as $id) {
                $query = $db->getQuery(true);
                $query->delete('#__assets')
                        ->where($db->qn('id') . ' = ' . $db->q($id));
                $db->setQuery($query);
                $db->query();
            }
        }

        // Remove #__menu records for good measure!
        $query = $db->getQuery(true);
        $query->select('id')
                ->from('#__menu')
                ->where($db->qn('type') . ' = ' . $db->q('component'))
                ->where($db->qn('menutype') . ' = ' . $db->q('main'))
                ->where($db->qn('link') . ' LIKE ' . $db->q('index.php?option=' . $this->_coalaweb_extension));
        $db->setQuery($query);
        $ids1 = $db->loadColumn();
        if (empty($ids1))
            $ids1 = array();
        $query = $db->getQuery(true);
        $query->select('id')
                ->from('#__menu')
                ->where($db->qn('type') . ' = ' . $db->q('component'))
                ->where($db->qn('menutype') . ' = ' . $db->q('main'))
                ->where($db->qn('link') . ' LIKE ' . $db->q('index.php?option=' . $this->_coalaweb_extension . '&%'));
        $db->setQuery($query);
        $ids2 = $db->loadColumn();
        if (empty($ids2))
            $ids2 = array();
        $ids = array_merge($ids1, $ids2);
        if (!empty($ids))
            foreach ($ids as $id) {
                $query = $db->getQuery(true);
                $query->delete('#__menu')
                        ->where($db->qn('id') . ' = ' . $db->q($id));
                $db->setQuery($query);
                $db->query();
            }
    }

    /**
     * Installs subextensions (modules, plugins) bundled with the main extension
     * 
     * @param JInstaller $parent 
     * @return JObject The subextension installation status
     */
    private function _installSubextensions($parent) {
        $src = $parent->getParent()->getPath('source');

        $db = JFactory::getDbo();

        $status = new JObject();
        $status->modules = array();
        $status->plugins = array();

        // Modules installation
        if (count($this->installation_queue['modules'])) {
            foreach ($this->installation_queue['modules'] as $folder => $modules) {
                if (count($modules))
                    foreach ($modules as $module => $modulePreferences) {
                        // Install the module
                        if (empty($folder))
                            $folder = 'site';
                        $path = "$src/modules/$folder/$module";
                        if (!is_dir($path)) {
                            $path = "$src/modules/$folder/mod_$module";
                        }
                        if (!is_dir($path)) {
                            $path = "$src/modules/$module";
                        }
                        if (!is_dir($path)) {
                            $path = "$src/modules/mod_$module";
                        }
                        if (!is_dir($path))
                            continue;
                        // Was the module already installed?
                        $sql = $db->getQuery(true)
                                ->select('COUNT(*)')
                                ->from('#__modules')
                                ->where($db->qn('module') . ' = ' . $db->q('mod_' . $module));
                        $db->setQuery($sql);
                        $count = $db->loadResult();
                        $installer = new JInstaller;
                        $result = $installer->install($path);
                        $status->modules[] = array(
                            'name' => 'mod_' . $module,
                            'client' => $folder,
                            'result' => $result
                        );
                        // Modify where it's published and its published state
                        if (!$count) {
                            // A. Position and state
                            list($modulePosition, $modulePublished) = $modulePreferences;
                            if ($modulePosition == 'cpanel') {
                                $modulePosition = 'icon';
                            }
                            $sql = $db->getQuery(true)
                                    ->update($db->qn('#__modules'))
                                    ->set($db->qn('position') . ' = ' . $db->q($modulePosition))
                                    ->where($db->qn('module') . ' = ' . $db->q('mod_' . $module));
                            if ($modulePublished) {
                                $sql->set($db->qn('published') . ' = ' . $db->q('1'));
                            }
                            $db->setQuery($sql);
                            $db->query();

                            // B. Change the ordering of back-end modules to 1 + max ordering
                            if ($folder == 'admin') {
                                $query = $db->getQuery(true);
                                $query->select('MAX(' . $db->qn('ordering') . ')')
                                        ->from($db->qn('#__modules'))
                                        ->where($db->qn('position') . '=' . $db->q($modulePosition));
                                $db->setQuery($query);
                                $position = $db->loadResult();
                                $position++;

                                $query = $db->getQuery(true);
                                $query->update($db->qn('#__modules'))
                                        ->set($db->qn('ordering') . ' = ' . $db->q($position))
                                        ->where($db->qn('module') . ' = ' . $db->q('mod_' . $module));
                                $db->setQuery($query);
                                $db->query();
                            }

                            // C. Link to all pages
                            $query = $db->getQuery(true);
                            $query->select('id')->from($db->qn('#__modules'))
                                    ->where($db->qn('module') . ' = ' . $db->q('mod_' . $module));
                            $db->setQuery($query);
                            $moduleid = $db->loadResult();

                            $query = $db->getQuery(true);
                            $query->select('*')->from($db->qn('#__modules_menu'))
                                    ->where($db->qn('moduleid') . ' = ' . $db->q($moduleid));
                            $db->setQuery($query);
                            $assignments = $db->loadObjectList();
                            $isAssigned = !empty($assignments);
                            if (!$isAssigned) {
                                $o = (object) array(
                                            'moduleid' => $moduleid,
                                            'menuid' => 0
                                );
                                $db->insertObject('#__modules_menu', $o);
                            }
                        }
                    }
            }
        }

        // Plugins installation
        if (count($this->installation_queue['plugins'])) {
            foreach ($this->installation_queue['plugins'] as $folder => $plugins) {
                if (count($plugins))
                    foreach ($plugins as $plugin => $published) {
                        $path = "$src/plugins/$folder/$plugin";
                        if (!is_dir($path)) {
                            $path = "$src/plugins/$folder/plg_$plugin";
                        }
                        if (!is_dir($path)) {
                            $path = "$src/plugins/$plugin";
                        }
                        if (!is_dir($path)) {
                            $path = "$src/plugins/plg_$plugin";
                        }
                        if (!is_dir($path))
                            continue;

                        // Was the plugin already installed?
                        $query = $db->getQuery(true)
                                ->select('COUNT(*)')
                                ->from($db->qn('#__extensions'))
                                ->where($db->qn('element') . ' = ' . $db->q($plugin))
                                ->where($db->qn('folder') . ' = ' . $db->q($folder));
                        $db->setQuery($query);
                        $count = $db->loadResult();

                        $installer = new JInstaller;
                        $result = $installer->install($path);

                        $status->plugins[] = array('name' => 'plg_' . $plugin, 'group' => $folder, 'result' => $result);

                        if ($published && !$count) {
                            $query = $db->getQuery(true)
                                    ->update($db->qn('#__extensions'))
                                    ->set($db->qn('enabled') . ' = ' . $db->q('1'))
                                    ->where($db->qn('element') . ' = ' . $db->q($plugin))
                                    ->where($db->qn('folder') . ' = ' . $db->q($folder));
                            $db->setQuery($query);
                            $db->query();
                        }
                    }
            }
        }

        return $status;
    }

    /**
     * Uninstalls subextensions (modules, plugins) bundled with the main extension
     * 
     * @param JInstaller $parent 
     * @return JObject The subextension uninstallation status
     */
    private function _uninstallSubextensions($parent) {
        jimport('joomla.installer.installer');

        $db = JFactory::getDBO();

        $status = new JObject();
        $status->modules = array();
        $status->plugins = array();

        $src = $parent->getParent()->getPath('source');

        // Modules uninstallation
        if (count($this->installation_queue['modules'])) {
            foreach ($this->installation_queue['modules'] as $folder => $modules) {
                if (count($modules))
                    foreach ($modules as $module => $modulePreferences) {
                        // Find the module ID
                        $sql = $db->getQuery(true)
                                ->select($db->qn('extension_id'))
                                ->from($db->qn('#__extensions'))
                                ->where($db->qn('element') . ' = ' . $db->q('mod_' . $module))
                                ->where($db->qn('type') . ' = ' . $db->q('module'));
                        $db->setQuery($sql);
                        $id = $db->loadResult();
                        // Uninstall the module
                        if ($id) {
                            $installer = new JInstaller;
                            $result = $installer->uninstall('module', $id, 1);
                            $status->modules[] = array(
                                'name' => 'mod_' . $module,
                                'client' => $folder,
                                'result' => $result
                            );
                        }
                    }
            }
        }

        // Plugins uninstallation
        if (count($this->installation_queue['plugins'])) {
            foreach ($this->installation_queue['plugins'] as $folder => $plugins) {
                if (count($plugins))
                    foreach ($plugins as $plugin => $published) {
                        $sql = $db->getQuery(true)
                                ->select($db->qn('extension_id'))
                                ->from($db->qn('#__extensions'))
                                ->where($db->qn('type') . ' = ' . $db->q('plugin'))
                                ->where($db->qn('element') . ' = ' . $db->q($plugin))
                                ->where($db->qn('folder') . ' = ' . $db->q($folder));
                        $db->setQuery($sql);

                        $id = $db->loadResult();
                        if ($id) {
                            $installer = new JInstaller;
                            $result = $installer->uninstall('plugin', $id, 1);
                            $status->plugins[] = array(
                                'name' => 'plg_' . $plugin,
                                'group' => $folder,
                                'result' => $result
                            );
                        }
                    }
            }
        }

        return $status;
    }

    /**
     * Removes obsolete files and folders
     * 
     * @param array $coalawebRemoveFiles 
     */
    private function _removeObsoleteFilesAndFolders($coalawebRemoveFiles) {
        // Remove files
        jimport('joomla.filesystem.file');
        if (!empty($coalawebRemoveFiles['files']))
            foreach ($coalawebRemoveFiles['files'] as $file) {
                $f = JPATH_ROOT . '/' . $file;
                if (!JFile::exists($f))
                    continue;
                JFile::delete($f);
            }

        // Remove folders
        jimport('joomla.filesystem.file');
        if (!empty($coalawebRemoveFiles['folders']))
            foreach ($coalawebRemoveFiles['folders'] as $folder) {
                $f = JPATH_ROOT . '/' . $folder;
                if (!JFolder::exists($f))
                    continue;
                JFolder::delete($f);
            }
    }

}